%This code is adapted from MATLAB answers post by Sam Chack
%https://www.mathworks.com/matlabcentral/answers/520494-how-can-i-plot-bifurcation-diagram-of-fractional-logistic-map#answer_1339151
%and was modofied by DGM
%https://www.mathworks.com/matlabcentral/answers/2141171-matlab-work-slowly-when-plot#answer_1493096
interval  = [0 4];
accuracy  =0.001;
reps      = 5000;     
numtoplot = 50;
initidx = reps - (numtoplot - 1);
svec = interval(1):accuracy:interval(2);
ns = numel(svec);

S = repmat(svec.',[1 numtoplot]);
X = zeros(ns,numtoplot);
Y = zeros(ns,numtoplot);
for sidx = 1:ns
	s = svec(sidx);
	x = zeros(1,numtoplot);
    y = zeros(1,numtoplot);
    r =2; 
    d = 0.2;
    h = 0.3;
    alpha = 0.95;
    h1 = h^alpha / gamma(1 + alpha);
	x(1) = 0.31;
    y(1) = 2;
    
	for n = 1:reps
		x(n+1)=x(n)+h1*(r*x(n)-x(n)*y(n));
        y(n+1)=y(n)+h1*(s-(1/r)*y(n)-d*x(n)+x(n)*y(n));
	end
	X(sidx,:) = x(initidx:reps);
    Y(sidx,:) = y(initidx:reps);
end

h1 = plot(S(:), X(:), '.', 'MarkerSize', 3, 'Color', 'r'); 
hold on
h2 = plot(S(:), Y(:), '.', 'MarkerSize', 3, 'Color', 'k'); 
lgd = legend('N(n) red','I(n) black');
lgd = legend('N(n) red','I(n) black');
lgd.FontSize=15
xlim([0.3 0.6])
xlabel('\sigma', 'FontSize', 14)
ylabel('N(n), I(n)', 'FontSize', 14)
sigma_star = 0.432277;
hold on;
plot(sigma_star, 0, 'bo', 'MarkerSize', 5, 'MarkerFaceColor', 'b');



